/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilenameDifferentiator
extends UIJob
implements IPartListener {
    private static final String SEPARATOR = " | ";
    private Map<String, Set<IEditorPart>> baseNames;

    public FilenameDifferentiator() {
        super("Install filename differentiator");
        EclipseUtil.setSystemForJob((Job)this);
        this.baseNames = new HashMap<String, Set<IEditorPart>>();
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        IWorkbenchWindow window;
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            window.getActivePage().addPartListener((IPartListener)this);
        }
        return Status.OK_STATUS;
    }

    public void partActivated(IWorkbenchPart part) {
        this.disambiguate(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partClosed(IWorkbenchPart part) {
        if (!(part instanceof IEditorPart)) {
            return;
        }
        String title = this.getBaseName(part);
        Map<String, Set<IEditorPart>> map = this.baseNames;
        synchronized (map) {
            Set<IEditorPart> parts = this.baseNames.get(title);
            if (parts != null) {
                parts.remove(part);
                if (parts.isEmpty()) {
                    this.baseNames.remove(title);
                } else if (parts.size() == 1) {
                    this.setTitle(parts.iterator().next(), title);
                }
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        this.disambiguate(part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disambiguate(IWorkbenchPart part) {
        Set<IEditorPart> list;
        if (!(part instanceof IEditorPart)) {
            return;
        }
        String title = this.getBaseName(part);
        Map<String, Set<IEditorPart>> map = this.baseNames;
        synchronized (map) {
            list = this.baseNames.get(title);
            if (list == null) {
                list = new HashSet<IEditorPart>();
                this.baseNames.put(title, list);
            }
            list.add((IEditorPart)part);
        }
        if (list.size() > 1) {
            Map<IEditorPart, String> newTitles = this.getUnambiguousTitles(list);
            for (Map.Entry<IEditorPart, String> entry : newTitles.entrySet()) {
                this.setTitle(entry.getKey(), entry.getValue());
            }
        }
    }

    private void setTitle(IEditorPart key, String value) {
        try {
            Method m = WorkbenchPart.class.getDeclaredMethod("setPartName", String.class);
            m.setAccessible(true);
            m.invoke((Object)key, value);
        }
        catch (Exception e) {
            IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected String getBaseName(IWorkbenchPart part) {
        String title = part.getTitle();
        return title.split(Pattern.quote(SEPARATOR))[0];
    }

    private Map<IEditorPart, String> getUnambiguousTitles(Collection<IEditorPart> list) {
        IPath path;
        HashMap<IEditorPart, IPath> map = new HashMap<IEditorPart, IPath>();
        int min = Integer.MAX_VALUE;
        for (IEditorPart part : list) {
            path = this.getPath(part);
            if (path == null) continue;
            min = Math.min(path.segmentCount(), min);
            map.put(part, path);
        }
        HashMap<IEditorPart, String> returnMap = new HashMap<IEditorPart, String>();
        HashSet<String> curSegments = new HashSet<String>();
        int i = 2;
        while (i <= min) {
            returnMap.clear();
            curSegments.clear();
            for (Map.Entry entry : map.entrySet()) {
                path = (IPath)entry.getValue();
                String segment = path.segment(path.segmentCount() - i);
                if (curSegments.contains(segment)) break;
                curSegments.add(segment);
                String title = String.valueOf(path.lastSegment()) + SEPARATOR + segment;
                returnMap.put((IEditorPart)entry.getKey(), title);
            }
            if (curSegments.size() == map.size()) {
                return returnMap;
            }
            ++i;
        }
        return Collections.emptyMap();
    }

    private IPath getPath(IEditorPart otherEditor) {
        IEditorInput input = otherEditor.getEditorInput();
        try {
            if (input instanceof IPathEditorInput) {
                return ((IPathEditorInput)input).getPath();
            }
            URI uri = (URI)input.getAdapter(URI.class);
            if (uri != null) {
                return new Path(String.valueOf(uri.getHost()) + '/' + uri.getPath());
            }
            if (input instanceof IURIEditorInput) {
                return URIUtil.toPath((URI)((IURIEditorInput)input).getURI());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void dispose() {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            page.removePartListener((IPartListener)this);
        }
        if (this.baseNames != null) {
            this.baseNames.clear();
            this.baseNames = null;
        }
    }
}

